<?php

namespace Microsoft\Graph\Generated\Communications\Calls\Item\Participants\Item\StopHoldMusic;

use Exception;
use Http\Promise\Promise;
use Microsoft\Graph\Generated\Models\ODataErrors\ODataError;
use Microsoft\Graph\Generated\Models\StopHoldMusicOperation;
use Microsoft\Kiota\Abstractions\BaseRequestBuilder;
use Microsoft\Kiota\Abstractions\HttpMethod;
use Microsoft\Kiota\Abstractions\RequestAdapter;
use Microsoft\Kiota\Abstractions\RequestInformation;

/**
 * Provides operations to call the stopHoldMusic method.
*/
class StopHoldMusicRequestBuilder extends BaseRequestBuilder 
{
    /**
     * Instantiates a new StopHoldMusicRequestBuilder and sets the default values.
     * @param array<string, mixed>|string $pathParametersOrRawUrl Path parameters for the request or a String representing the raw URL.
     * @param RequestAdapter $requestAdapter The request adapter to use to execute the requests.
    */
    public function __construct($pathParametersOrRawUrl, RequestAdapter $requestAdapter) {
        parent::__construct($requestAdapter, [], '{+baseurl}/communications/calls/{call%2Did}/participants/{participant%2Did}/stopHoldMusic');
        if (is_array($pathParametersOrRawUrl)) {
            $this->pathParameters = $pathParametersOrRawUrl;
        } else {
            $this->pathParameters = ['request-raw-url' => $pathParametersOrRawUrl];
        }
    }

    /**
     * Reincorporate a participant previously put on hold to the call.
     * @param StopHoldMusicPostRequestBody $body The request body
     * @param StopHoldMusicRequestBuilderPostRequestConfiguration|null $requestConfiguration Configuration for the request such as headers, query parameters, and middleware options.
     * @return Promise<StopHoldMusicOperation|null>
     * @throws Exception
     * @link https://learn.microsoft.com/graph/api/participant-stopholdmusic?view=graph-rest-1.0 Find more info here
    */
    public function post(StopHoldMusicPostRequestBody $body, ?StopHoldMusicRequestBuilderPostRequestConfiguration $requestConfiguration = null): Promise {
        $requestInfo = $this->toPostRequestInformation($body, $requestConfiguration);
        $errorMappings = [
                'XXX' => [ODataError::class, 'createFromDiscriminatorValue'],
        ];
        return $this->requestAdapter->sendAsync($requestInfo, [StopHoldMusicOperation::class, 'createFromDiscriminatorValue'], $errorMappings);
    }

    /**
     * Reincorporate a participant previously put on hold to the call.
     * @param StopHoldMusicPostRequestBody $body The request body
     * @param StopHoldMusicRequestBuilderPostRequestConfiguration|null $requestConfiguration Configuration for the request such as headers, query parameters, and middleware options.
     * @return RequestInformation
    */
    public function toPostRequestInformation(StopHoldMusicPostRequestBody $body, ?StopHoldMusicRequestBuilderPostRequestConfiguration $requestConfiguration = null): RequestInformation {
        $requestInfo = new RequestInformation();
        $requestInfo->urlTemplate = $this->urlTemplate;
        $requestInfo->pathParameters = $this->pathParameters;
        $requestInfo->httpMethod = HttpMethod::POST;
        if ($requestConfiguration !== null) {
            $requestInfo->addHeaders($requestConfiguration->headers);
            $requestInfo->addRequestOptions(...$requestConfiguration->options);
        }
        $requestInfo->tryAddHeader('Accept', "application/json");
        $requestInfo->setContentFromParsable($this->requestAdapter, "application/json", $body);
        return $requestInfo;
    }

    /**
     * Returns a request builder with the provided arbitrary URL. Using this method means any other path or query parameters are ignored.
     * @param string $rawUrl The raw URL to use for the request builder.
     * @return StopHoldMusicRequestBuilder
    */
    public function withUrl(string $rawUrl): StopHoldMusicRequestBuilder {
        return new StopHoldMusicRequestBuilder($rawUrl, $this->requestAdapter);
    }

}
