// database/migrations/xxxx_xx_xx_create_ven_ingresos_table.php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateVenIngresosTable extends Migration
{
    public function up()
    {
        Schema::create('ven_ingresos', function (Blueprint $table) {
            $table->bigIncrements('id_ing');
            $table->dateTime('date')->nullable();
            $table->string('description', 500);
            $table->string('voucher', 100);
            $table->integer('type_payment')->nullable();
            $table->string('transaction_type', 1);
            $table->decimal('amount', 10, 0)->nullable();
            $table->timestamps();
            $table->bigInteger('user')->nullable();
        });
    }

    public function down()
    {
        Schema::dropIfExists('ven_ingresos');
    }
}
