<?php

namespace App\Repositories;

use App\Models\tbempresa;
use DB;

class tbempresaRepository {
    private $model;
    public function __construct(){
        $this->model = new tbempresa();
    }
    public function get($id) {

        return $this->model->find($id);
    }
    public function getAll() {
        return $this->model->orderBy('idemp', 'desc')->get();
    }
    public function getEmpUser($correo) {
        return $this->model
        ->join('tbempresa_user','tbempresa.idemp','tbempresa_user.idemp')
            ->join('users','tbempresa_user.iduser','users.id')
            ->where('users.email','=',$correo)
            ->where('tbempresa.estado','=',true)
            ->select(   'tbempresa.idemp',
                        'tbempresa.nombre',
                        'tbempresa.ruc'
            )->orderBy('tbempresa.idemp', 'desc')->get();
    }
    public function save($data) {
        $return = (object)[
            'response' => false
        ];
        try {
            DB::beginTransaction();
            if($data->idemp > 0)
            {
                $this->model->exists = true;
                $this->model->idemp=$data->idemp;
            }
            $this->model->nombre = strtoupper($data->nombre);
            $this->model->razonsocial = strtoupper($data->razonsocial);
            $this->model->ruc= strtoupper($data->ruc);
            $this->model->direccion= strtoupper($data->direccion);
            $this->model->sector= strtoupper($data->sector);
            $this->model->telefono= strtoupper($data->telefono);
            $this->model->telefono1= strtoupper($data->telefono1);
            $this->model->celular= strtoupper($data->celular);            
            $this->model->correo= $data->correo;
            $this->model->correo1= $data->correo1;
            $this->model->save();
            $return->response = true;
            DB::commit();
        } catch (\Exception $e){
            echo"xx:".$e;
            DB::rollBack();
        }
        return json_encode($return);
    }
}
