<?php

namespace App\Http\Controllers\Auth;

use App\Http\Controllers\Controller;
use App\Models\User;
use App\Models\Uspaciente;
use App\Providers\RouteServiceProvider;
use App\Models\Cliente;
use Illuminate\Auth\Events\Registered;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Hash;
use Illuminate\Validation\Rules;

class RegisteredUserController extends Controller
{
    /**
     * Display the registration view.
     *
     * @return \Illuminate\View\View
     */
    public function create()
    {
        return view('auth.register');
    }

    /**
     * Handle an incoming registration request.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\RedirectResponse
     *
     * @throws \Illuminate\Validation\ValidationException
     */
    public function store(Request $request)
    {

        
        $paciente=Uspaciente::where('codigo',$request->codigo)->first();
        if(!isset($paciente) || $paciente->utilizado==1)
            return redirect()->back()->with('errorscod','Por favor igrese un codigo valido!!');

        $request->validate([
            'name' => ['required', 'string', 'max:255'],
            'email' => ['required', 'string', 'email', 'max:255', 'unique:users'],
            'password' => ['required', 'confirmed', Rules\Password::defaults()],
            'password' => ['required', 'confirmed', Rules\Password::defaults()],
            'codigo' => ['required','string','max:128'],
            'terminos_y_condiciones'=>['required']
        ]);

        $user = User::create([
            'name' => $request->name,
            'email' => $request->email,
            'password' => Hash::make($request->password),
            'codigo' => $request->codigo,
            'estado' =>1,
        ]);

        Uspaciente::where('codigo',$request->codigo)
            ->update(['utilizado' => 1,'iduser'=>$user->id]);

        
        $user->addRole('user');
        event(new Registered($user));

        Auth::login($user);

        return redirect(RouteServiceProvider::HOME);
    }

    public function storeExtern(Request $request)
    {
         $cliente=cliente::where('cli_usuario',"soporte@gmailcom")->first();
        // if(!isset($paciente) || $paciente->utilizado==1)
        //     return redirect()->back()->with('errorscod','Por favor igrese un codigo valido!!');

        // $request->validate([
        //     'name' => ['required', 'string', 'max:255'],
        //     'email' => ['required', 'string', 'email', 'max:255', 'unique:users'],
        //     'password' => ['required', 'confirmed', Rules\Password::defaults()],
        //     'password' => ['required', 'confirmed', Rules\Password::defaults()],
        //     'codigo' => ['required','string','max:128'],
        //     'terminos_y_condiciones'=>['required']
        // ]);

        $user = User::create([
            'name' => $request->name,
            'email' => $cliente->cli_usuario,
            'password' => Hash::make("123456"),
            'codigo' => "123",
            'estado' =>1,
        ]);

        Uspaciente::where('codigo',$request->codigo)
            ->update(['utilizado' => 1,'iduser'=>$user->id]);

        
        $user->addRole('user');
        event(new Registered($user));

        Auth::login($user);

        return redirect(RouteServiceProvider::HOME);
    }
}
