<?php
use App\Http\Controllers\Auth\RegisteredUserController;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\tbempresaController;
use App\Http\Controllers\UserController;
use App\Http\Controllers\Reports\ReportsController;

use App\Http\Controllers\Carga\CargaController;
use App\Http\Controllers\HomeController;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/
require __DIR__.'/auth.php';
//Dashboard
Route::get('/', [HomeController::class, 'index'])->middleware(['auth'])->name('home');
//Descarga de archivos
Route::get('/downloadAcces', [HomeController::class, 'downloadAcces'])->middleware(['auth'])->name('downloadAcces');
Route::get('/downloadDocument', [HomeController::class, 'downloadDocument'])->middleware(['auth'])->name('downloadDocument');
Route::get('/downloadBulletins', [HomeController::class, 'downloadBulletins'])->middleware(['auth'])->name('downloadBulletins');
//Carga de notificaciones
Route::get('/cargaNotificacionesDiarias', [CargaController::class, 'index'])->middleware(['auth'])->name('carga archivo');
Route::post('/cargaUpload', [CargaController::class, 'upload'])->middleware(['auth'])->name('cargaUpload');
Route::get('/listarCargas', [CargaController::class, 'listarCargas'])->middleware(['auth'])->name('carga archivo');
Route::delete('/destroy/{idcarga}', [CargaController::class, 'destroy'])->middleware(['auth'])->name('carga.destroy');


//Listado de Reportes
Route::get('/listaintegracion', [ReportsController::class, 'listaIntegracion'])->middleware(['auth'])->name('listaintegracion');
Route::post('/listaintegracion', [ReportsController::class, 'listaIntegracion'])->middleware(['auth'])->name('listaintegracion');
Route::get('/listadescargas', [ReportsController::class, 'listadescargas'])->middleware(['auth'])->name('listadescargas');
Route::post('/listadescargas', [ReportsController::class, 'listadescargas'])->middleware(['auth'])->name('listadescargas');
Route::get('/listanotificaciones', [ReportsController::class, 'listanotificaciones'])->middleware(['auth'])->name('listanotificaciones');
Route::post('/listanotificaciones', [ReportsController::class, 'listanotificaciones'])->middleware(['auth'])->name('listanotificaciones');
Route::get('/listadocumentos', [ReportsController::class, 'listadocumentos'])->middleware(['auth'])->name('listadocumentos');
Route::post('/listadocumentos', [ReportsController::class, 'listadocumentos'])->middleware(['auth'])->name('listadocumentos');

/*Empresa*/
Route::get('/empresa', [tbempresaController::class, 'index'])->middleware(['auth'])->name('index empresa');
Route::get('/empresa/perfil', [tbempresaController::class, 'perfil'])->middleware(['auth'])->name('perfil empresa');
Route::post('/empresa/save', [tbempresaController::class, 'save'])->middleware(['auth'])->name('save empresa');
Route::get('/empresa/getEmpresas', [tbempresaController::class, 'getEmpresas'])->middleware(['auth'])->name('getEmpresas empresa');
/*Modulo usuarios*/
Route::get('/admin/creteExtern', [RegisteredUserController::class, 'storeExtern'])->middleware(['auth'])->name('users.index');
Route::get('/admin/users', [UserController::class, 'index'])->middleware(['auth'])->name('users.index');
Route::post('/admin/users/create', [UserController::class, 'store'])->middleware(['auth'])->name('users.create');
Route::post('/admin/users/rol', [UserController::class, 'getRol'])->middleware(['auth'])->name('users.rol');
Route::get('/admin/users/edit/{id}', [UserController::class, 'edit'])->middleware(['auth'])->name('users.edit');
Route::post('/admin/users/update', [UserController::class, 'update'])->middleware(['auth'])->name('users.update');
Route::post('admin/empresa', [UserController::class, 'empresa'])->middleware(['auth'])->name('users.empresa');

