<x-app-layout>
<div class="container mx-auto py-8">
    <form method="GET" action="{{ route('listadescargas') }}" class="mb-4">
        <div class="row">
            @if(Auth::user()->hasRole(['supadmin']) )
            <div class='col-md-4'><label for="empresa">Empresa:</label>
                <select name="empresa" id="empresa" class="form-control" required>
                    <option value="">Seleccione una empresa</option>
                    @foreach($empresas as $empresa)
                        <option value="{{ $empresa->org_id }}" {{ request('empresa') == $empresa->org_id ? 'selected' : '' }}>
                            {{ $empresa->org_id }} - {{ $empresa->org_nombre }}
                        </option>
                    @endforeach
                </select>
                </div>
                
            @endif
            <div class='col-md-3'>
                <label for="start_date" class="mr-2">Fecha Inicio:</label>
                <input type="date" id="start_date" name="start_date" class="form-control" value="{{ $start_date}}">
            </div>
            <div class='col-md-3'>
                <label for="end_date" class="mr-2 ml-4">Fecha Final:</label>
                <input type="date" id="end_date" name="end_date" class="form-control" value="{{ $end_date}}">
                
            </div>
            <div class='col-md-1'>
                <label for="end_date" class="mr-2 ml-4">&nbsp;</label>
                <button type="submit" class="btn btn-primary">Filtrar</button>
            </div>          
        </div>
    </form>

    <table class="table table-striped table-bordered dataTable">
        <thead>
            <tr>
                <th class="py-2">Fecha Descarga</th>
                <th class="py-2">Documento</th>
                <th class="py-2">No. Descargas</th>
            </tr>
        </thead>
        <tbody>
            @php
                $totalDescargas = 0;
            @endphp
            @foreach($documents as $document)
                <tr>
                    <td class="py-2">{{ $document->fecha_modifica }}</td>
                    <td class="py-2">{{ $document->titulo }}</td>
                    <td class="py-2">{{ $document->conteo }}</td>
                </tr>
                @php
                    $totalDescargas += $document->conteo;
                @endphp
            @endforeach
        </tbody>
        <tfoot>
            <tr>
            <td class="py-2 font-bold" colspan="2">Total Descargas</td>
            <td class="py-2 font-bold">{{ $totalDescargas }}</td>
            </tr>
        </tfoot>
    </table>
    <div class="mt-4">
        {{ $documents->appends(Request::only(['start_date','end_date','empresa']))->render() }}
    </div>
</div>

</x-app-layout>