<x-app-layout>

<div id="spinner-border" class="spinner-border text-primary" role="status" style="display: none;">
    <span class="sr-only">Loading...</span>
</div>
<div id="spinner-image" class="text-center"  style="display: none;" >
    <img src="{{ asset('assets/temptk/img/cargando.gif') }}" alt="Cargando...">
</div>
<script>
    document.querySelector('form').addEventListener('submit', function() {
        document.getElementById('spinner-border').style.display = 'block';
        document.getElementById('spinner-image').style.display = 'block';
    });
</script>
<div class="container mx-auto mt-5">
    <div class="card">
        @if (session('success'))
            <div class="alert alert-success">
                {{ session('success') }}
            </div>
        @endif
        @if (session('error'))
            <div class="alert alert-warning">
                {{ session('error') }}
            </div>
        @endif
    
        <div class="card-body">
            <form action="{{ route('cargaUpload') }}" method="POST" enctype="multipart/form-data">
                @csrf
            <div class="form-group mb-3">
                <label for="empresa">Empresa</label>
                <select name="empresa" id="empresa" class="form-control" required>
                    <option value="">Seleccione una empresa</option>
                    @foreach($empresas as $empresa)
                        <option value="{{ $empresa->org_id }}">{{ $empresa->org_id }} - {{ $empresa->org_nombre }}</option>
                    @endforeach
                </select>
            </div>
                <div class="form-group">
                    <label for="file">Seleccione el archivo Excel</label>
                    <input type="file" name="file" class="form-control" required>
                </div>
                <button type="submit" class="btn btn-primary mt-3">Cargar</button>
            </form>
        </div>
    </div>
</div>
</x-app-layout>