<?php

namespace App\Http\Controllers;

use App\Repositories\tbempresaRepository;
use Illuminate\Http\Request;
use App\Http\Controllers\Clases\Utilidades;
use Lang;
use PhpOffice\PhpSpreadsheet\Writer\Xlsx\Rels;

class tbempresaController extends Controller
{
    private $_tbempresa;

    public function __construct(tbempresaRepository $_tbempresa)
        {
            $this->_tbempresa = $_tbempresa;
            $this->middleware('auth');
            $this->_util=new Utilidades();
        }
    public function index()
    {
        return view(
            'empresa.index', [
                'model' => $this->_tbempresa->getAll()
            ]
        );
    }
    public function Perfil(Request $req)
    {
        $this->_util->inicializaMenu($req);
        $req->session()->put('activePerf',  Lang::get('auth.activePerf'));
        $req->session()->put('varPerf',  Lang::get('auth.active'));
        $req->session()->put('breadCumbp',Lang::get('auth.breadcumPerf'));
        $req->session()->put('breadCumbs',Lang::get('auth.detailbreadcumPerf'));
        $req->session()->put('breadImg', Lang::get('auth.icoPerf'));
        return view(
            'empresa.perfil', [
                'model' => $this->_tbempresa->get(session('empresa'))
            ]
        );
    }

    public function getEmpresas()
    {        return $this->_tbempresa->getAll();
    }

    public function add()
    {
        return view('empresa.add');
    }
    public function save(Request $req)
    {
        $req['activo']=1;
        $req['creado']=date("Y-m-d H:i:s.u");
        $req['modificado']=date("Y-m-d H:i:s.u");
        if($req['regagua']="on"){
            $req['regagua']=1;
        }else{
            $req['regagua']=0;
        }
        if($req['regsaldos']="on"){
            $req['regsaldos']=1;
        }else{
            $req['regsaldos']=0;
        }
        if($req['regmultas']="on"){
            $req['regmultas']=1;
        }else{
            $req['regmultas']=0;
        }

        $data = (object)[
            'idemp'=> $req->input('idemp'),
            'nombre' => $req->input('nombre'),
            'razonsocial' => $req->input('razonsocial'),
            'ruc' => $req->input('ruc'),
            'direccion' => $req->input('direccion'),
            'sector'=>$req->input('sector'),
            'telefono'=>$req->input('telefono'),
            'telefono1'=>$req->input('telefono1'),
            'celular'=>$req->input('celular'),            
            'correo'=>$req->input('correo'),
            'correo1'=>$req->input('correo1')
        ];
        return $this->_tbempresa->save($data);
    }

}
