<?php

namespace App\Http\Controllers\Auth;

use App\Http\Controllers\Controller;
use App\Http\Requests\Auth\LoginRequest;
use App\Providers\RouteServiceProvider;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use App\Models\tbempresa as Empresa;

class AuthenticatedSessionController extends Controller
{
    /**
     * Display the login view.
     *
     * @return \Illuminate\View\View
     */
    public function create()
    {
        return view('auth.login');
    }

    /**
     * Handle an incoming authentication request.
     *
     * @param  \App\Http\Requests\Auth\LoginRequest  $request
     * @return \Illuminate\Http\RedirectResponse
     */
    public function store(LoginRequest $request)
    {
        $request->authenticate();
        $request->session()->regenerate();
        //$userId = Auth::id();
        //$request->session()->put('user_id', $userId);

        $user = Auth::user()->fresh();
        $userId = $user->id;
        $request->session()->put('user_id', $userId);

       
      // var_dump($userId);

        $empresa = Empresa::join('tbempresauser', 'tbempresa.idemp', '=', 'tbempresauser.idemp')
            ->where('tbempresauser.iduser', $userId )
            ->select('tbempresa.idemp', 'tbempresa.nombre')
            ->first();
        if ($empresa) {
            $request->session()->put('empresa', $empresa->idemp);
            $request->session()->put('nomempresa', $empresa->nombre);
        }

        return redirect()->intended(RouteServiceProvider::HOME);
    }

    /**
     * Destroy an authenticated session.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\RedirectResponse
     */
    public function destroy(Request $request)
    {
        Auth::guard('web')->logout();
        $request->session()->invalidate();
        $request->session()->regenerateToken();
        return redirect()->away('login');
    }

}
