<?php

namespace Microsoft\Graph\Generated\DeviceManagement\WindowsMalwareInformation\Item\DeviceMalwareStates;

use Exception;
use Http\Promise\Promise;
use Microsoft\Graph\Generated\DeviceManagement\WindowsMalwareInformation\Item\DeviceMalwareStates\Count\CountRequestBuilder;
use Microsoft\Graph\Generated\DeviceManagement\WindowsMalwareInformation\Item\DeviceMalwareStates\Item\MalwareStateForWindowsDeviceItemRequestBuilder;
use Microsoft\Graph\Generated\Models\MalwareStateForWindowsDevice;
use Microsoft\Graph\Generated\Models\MalwareStateForWindowsDeviceCollectionResponse;
use Microsoft\Graph\Generated\Models\ODataErrors\ODataError;
use Microsoft\Kiota\Abstractions\BaseRequestBuilder;
use Microsoft\Kiota\Abstractions\HttpMethod;
use Microsoft\Kiota\Abstractions\RequestAdapter;
use Microsoft\Kiota\Abstractions\RequestInformation;

/**
 * Provides operations to manage the deviceMalwareStates property of the microsoft.graph.windowsMalwareInformation entity.
*/
class DeviceMalwareStatesRequestBuilder extends BaseRequestBuilder 
{
    /**
     * Provides operations to count the resources in the collection.
    */
    public function count(): CountRequestBuilder {
        return new CountRequestBuilder($this->pathParameters, $this->requestAdapter);
    }
    
    /**
     * Provides operations to manage the deviceMalwareStates property of the microsoft.graph.windowsMalwareInformation entity.
     * @param string $malwareStateForWindowsDeviceId The unique identifier of malwareStateForWindowsDevice
     * @return MalwareStateForWindowsDeviceItemRequestBuilder
    */
    public function byMalwareStateForWindowsDeviceId(string $malwareStateForWindowsDeviceId): MalwareStateForWindowsDeviceItemRequestBuilder {
        $urlTplParams = $this->pathParameters;
        $urlTplParams['malwareStateForWindowsDevice%2Did'] = $malwareStateForWindowsDeviceId;
        return new MalwareStateForWindowsDeviceItemRequestBuilder($urlTplParams, $this->requestAdapter);
    }

    /**
     * Instantiates a new DeviceMalwareStatesRequestBuilder and sets the default values.
     * @param array<string, mixed>|string $pathParametersOrRawUrl Path parameters for the request or a String representing the raw URL.
     * @param RequestAdapter $requestAdapter The request adapter to use to execute the requests.
    */
    public function __construct($pathParametersOrRawUrl, RequestAdapter $requestAdapter) {
        parent::__construct($requestAdapter, [], '{+baseurl}/deviceManagement/windowsMalwareInformation/{windowsMalwareInformation%2Did}/deviceMalwareStates{?%24count,%24expand,%24filter,%24orderby,%24search,%24select,%24skip,%24top}');
        if (is_array($pathParametersOrRawUrl)) {
            $this->pathParameters = $pathParametersOrRawUrl;
        } else {
            $this->pathParameters = ['request-raw-url' => $pathParametersOrRawUrl];
        }
    }

    /**
     * List properties and relationships of the malwareStateForWindowsDevice objects.
     * @param DeviceMalwareStatesRequestBuilderGetRequestConfiguration|null $requestConfiguration Configuration for the request such as headers, query parameters, and middleware options.
     * @return Promise<MalwareStateForWindowsDeviceCollectionResponse|null>
     * @throws Exception
     * @link https://learn.microsoft.com/graph/api/intune-devices-malwarestateforwindowsdevice-list?view=graph-rest-1.0 Find more info here
    */
    public function get(?DeviceMalwareStatesRequestBuilderGetRequestConfiguration $requestConfiguration = null): Promise {
        $requestInfo = $this->toGetRequestInformation($requestConfiguration);
        $errorMappings = [
                'XXX' => [ODataError::class, 'createFromDiscriminatorValue'],
        ];
        return $this->requestAdapter->sendAsync($requestInfo, [MalwareStateForWindowsDeviceCollectionResponse::class, 'createFromDiscriminatorValue'], $errorMappings);
    }

    /**
     * Create a new malwareStateForWindowsDevice object.
     * @param MalwareStateForWindowsDevice $body The request body
     * @param DeviceMalwareStatesRequestBuilderPostRequestConfiguration|null $requestConfiguration Configuration for the request such as headers, query parameters, and middleware options.
     * @return Promise<MalwareStateForWindowsDevice|null>
     * @throws Exception
     * @link https://learn.microsoft.com/graph/api/intune-devices-malwarestateforwindowsdevice-create?view=graph-rest-1.0 Find more info here
    */
    public function post(MalwareStateForWindowsDevice $body, ?DeviceMalwareStatesRequestBuilderPostRequestConfiguration $requestConfiguration = null): Promise {
        $requestInfo = $this->toPostRequestInformation($body, $requestConfiguration);
        $errorMappings = [
                'XXX' => [ODataError::class, 'createFromDiscriminatorValue'],
        ];
        return $this->requestAdapter->sendAsync($requestInfo, [MalwareStateForWindowsDevice::class, 'createFromDiscriminatorValue'], $errorMappings);
    }

    /**
     * List properties and relationships of the malwareStateForWindowsDevice objects.
     * @param DeviceMalwareStatesRequestBuilderGetRequestConfiguration|null $requestConfiguration Configuration for the request such as headers, query parameters, and middleware options.
     * @return RequestInformation
    */
    public function toGetRequestInformation(?DeviceMalwareStatesRequestBuilderGetRequestConfiguration $requestConfiguration = null): RequestInformation {
        $requestInfo = new RequestInformation();
        $requestInfo->urlTemplate = $this->urlTemplate;
        $requestInfo->pathParameters = $this->pathParameters;
        $requestInfo->httpMethod = HttpMethod::GET;
        if ($requestConfiguration !== null) {
            $requestInfo->addHeaders($requestConfiguration->headers);
            if ($requestConfiguration->queryParameters !== null) {
                $requestInfo->setQueryParameters($requestConfiguration->queryParameters);
            }
            $requestInfo->addRequestOptions(...$requestConfiguration->options);
        }
        $requestInfo->tryAddHeader('Accept', "application/json");
        return $requestInfo;
    }

    /**
     * Create a new malwareStateForWindowsDevice object.
     * @param MalwareStateForWindowsDevice $body The request body
     * @param DeviceMalwareStatesRequestBuilderPostRequestConfiguration|null $requestConfiguration Configuration for the request such as headers, query parameters, and middleware options.
     * @return RequestInformation
    */
    public function toPostRequestInformation(MalwareStateForWindowsDevice $body, ?DeviceMalwareStatesRequestBuilderPostRequestConfiguration $requestConfiguration = null): RequestInformation {
        $requestInfo = new RequestInformation();
        $requestInfo->urlTemplate = $this->urlTemplate;
        $requestInfo->pathParameters = $this->pathParameters;
        $requestInfo->httpMethod = HttpMethod::POST;
        if ($requestConfiguration !== null) {
            $requestInfo->addHeaders($requestConfiguration->headers);
            $requestInfo->addRequestOptions(...$requestConfiguration->options);
        }
        $requestInfo->tryAddHeader('Accept', "application/json");
        $requestInfo->setContentFromParsable($this->requestAdapter, "application/json", $body);
        return $requestInfo;
    }

    /**
     * Returns a request builder with the provided arbitrary URL. Using this method means any other path or query parameters are ignored.
     * @param string $rawUrl The raw URL to use for the request builder.
     * @return DeviceMalwareStatesRequestBuilder
    */
    public function withUrl(string $rawUrl): DeviceMalwareStatesRequestBuilder {
        return new DeviceMalwareStatesRequestBuilder($rawUrl, $this->requestAdapter);
    }

}
