<x-app-layout>
<div class="container mx-auto py-8">
    
    <form method="GET" action="{{ route('listadocumentos') }}" class="mb-4">
        <div class="row">
            <div class='col-md-3'>
                <label for="start_date" class="mr-2">Fecha Inicio:</label>
                <input type="date" id="start_date" name="start_date" class="form-control" value="{{ $start_date}}">
            </div>
            <div class='col-md-3'>
                <label for="end_date" class="mr-2 ml-4">Fecha Final:</label>
                <input type="date" id="end_date" name="end_date" class="form-control" value="{{ $end_date}}">
                
            </div>
            <div class='col-md-1'>
                <label for="end_date" class="mr-2 ml-4">&nbsp;</label>
                <button type="submit" class="btn btn-primary">Filtrar</button>
            </div>          
        </div>
    </form>

    <table class="table table-striped table-bordered dataTable">
        <thead>
            <tr>
                <th class="py-2">Fecha de Creación</th>
                <th class="py-2">Nombre Documento</th>
                <th class="py-2">Emisor (Carpeta 2)</th>
                <th class="py-2">Area de Contenido (Carpeta 1)</th>
                <th class="py-2">Enlace</th>               
            </tr>
        </thead>
        <tbody>
        @foreach($documents as $document)
                <tr>
                    <td class="py-2">{{ $document->fecha_creacion }}</td>
                    <td class="py-2">{{ $document->titulo }}</td>
                    <td class="py-2">{{ $document->nombre1 }}</td>
                    <td class="py-2">{{ $document->nombre2 }}</td>
                    <td class="py-2">https://app.virtualex.ec/app/visor.php?id={{ (new \App\Http\Controllers\Clases\Security)->encriptar($document->id_documento) }}</td>
                </tr>
            @endforeach
        </tbody>
    </table>
    <div class="mt-4">
@if ($documents instanceof \Illuminate\Pagination\LengthAwarePaginator)
    {{ $documents->links() }}
@endif
    </div>
</div>

</x-app-layout>