<x-app-layout>
@if(session('success'))
    <div class="alert alert-success alert-dismissible fade show" role="alert">
        {{ session('success') }}
        <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
    </div>
@endif

<div class="py-12">
    <div class="max-w-7xl mx-auto sm:px-6 lg:px-8">
        <div class="bg-white overflow-hidden shadow-xl sm:rounded-lg p-6">
            <!-- Filter Section -->
            <div class="mb-6">
                <form method="GET"  class="mb-4">
                    <div class="flex items-center">
                        <label for="start_date" class="mr-2">Fecha Inicio:</label>
                        <input type="date" id="start_date" name="start_date" class="border rounded py-2 px-3" value="{{ $startDate}}">
                        <label for="end_date" class="mr-2 ml-4">Fecha Final:</label>
                        <input type="date" id="end_date" name="end_date" class="border rounded py-2 px-3" value="{{ $endDate}}">
                        <button type="submit" class="btn btn-primary">Filtrar</button>
                    </div>
                </form>                
            </div>

            <!-- Table Section -->
            <div class="overflow-x-auto">
                <table class="table table-striped table-bordered dataTable">
                    <thead >
                        <tr>
                            <th >ID</th>
                            <th >Institucion</th>
                            <th >Fecha de Carga</th>
                            <th >Actions</th>
                        </tr>
                    </thead>
                    <tbody class="bg-white divide-y divide-gray-200">
                        @foreach($cargas as $carga)
                            <tr>
                                <td class="px-6 py-4 whitespace-nowrap">{{ $carga->idcarga }}</td>
                                <td class="px-6 py-4 whitespace-nowrap">{{ $carga->org_nombre }}</td>
                                <td class="px-6 py-4 whitespace-nowrap">{{ $carga->fecha }}</td>
                                <td class="px-6 py-4 whitespace-nowrap">
                                    <form method="POST" action="{{ route('carga.destroy', $carga->idcarga) }}" 
                                          onsubmit="return confirm('Esta seguro que desea eliminar este registro, se eliminarán las notificaciones relacionadas?');">
                                        @csrf
                                        @method('DELETE')
                                        <button type="submit" class="btn btn-primary">
                                            Eliminar
                                        </button>
                                    </form>
                                </td>
                            </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>

</x-app-layout>