<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateGncatalogoTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('gncatalogo', function (Blueprint $table) {
        $table->id('idcat');
        $table->string('nombre',500);
        $table->string('codigo',20);
        $table->string('descripcion',1000)->nullable();
        $table->boolean('estado')->nullable();
        $table->timestamps();
        });

        Schema::create('gndetcatalogo', function (Blueprint $table) {
            $table->id('iddetcat');
            $table->unsignedBigInteger('idcat');
            $table->string('nombre',500);
            $table->string('nomenclatura',20);
            $table->string('codigo',1000)->nullable();
            $table->text('descripcion')->nullable();
            $table->boolean('estado')->nullable();
            $table->timestamps();
            $table->foreign('idcat')->references('idcat')->on('gncatalogo')
                ->onUpdate('cascade')->onDelete('cascade');
        });

    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('gncatalogo');
        Schema::dropIfExists('gndetcatalogo');
    }
}
