<?php

namespace App\Http\Controllers\Carga;
use App\Http\Controllers\Controller;
use App\Http\Controllers\Clases\Utilidades;
use App\Models\Documento;
use App\Models\Sesexterna;
use App\Models\Topdoc;
use App\Repositories\homeRepository;
use Illuminate\Http\Request;
use App\Models\CargaNotifications;
use App\Models\Notifications;
use App\Models\tbempresauser as EmpresaUser; // Ensure this model exists or is correctly referenced

use Illuminate\Support\Facades\Auth;
use phpseclib3\Crypt\Common\Formats\Signature\Raw;
//use DB;
use PhpOffice\PhpSpreadsheet\Spreadsheet;
use PhpOffice\PhpSpreadsheet\Writer\Xlsx;
use Illuminate\Support\Facades\DB;
use App\Models\Organizacion;
use Lang;


class CargaController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    private $_homerepo;
    private $_facturarepo;
    private $_pago;

    public function __construct()
    {
        $this->middleware('auth');
        //$this->_homerepo = $_homerepo;
        $this->_util = new Utilidades();
    }


    /**
     * Show the application dashboard.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $req)
    {
        $user = Auth::user();
       // Coloca valores para menu activo y breadcumbs
        $this->_util->inicializaMenu($req);
        $req->session()->put('activeCarg',  Lang::get('carga.actCarg'));
        $req->session()->put('varCarg',  Lang::get('carga.active'));
        $req->session()->put('breadCumbp',Lang::get('carga.breadcumCarg'));
        $req->session()->put('breadCumbs',Lang::get('carga.detailbreadcumCarg'));
        $req->session()->put('breadImg', Lang::get('carga.icoCarg'));

        date_default_timezone_set('America/Guayaquil');

        $mesHoy = date("m");
        $anioHoy = date("Y");
        $diaHoy = date("d");

        $startDate = $req->input('start_date') ?: date('Y-m-01');
        $endDate = $req->input('end_date') ?: date('Y-m-d');


        $empresas = Organizacion::join('cliente', 'organizacion.org_id', '=', 'cliente.org_id')
            ->join('configession', function($join) {
            $join->on('cliente.cli_usuario', '=', 'configession.correo')
                 ->where('cliente.cli_usuario', '!=', '');
            })
            ->select('organizacion.org_id', 'organizacion.org_nombre')
            ->get();

        return view('carga.index', compact('empresas'));
        } 
       public function upload(Request $req)
    {
        $this->validate($req, [
            'file' => 'required|mimes:xlsx'
        ]);

        $file = $req->file('file');
        $spreadsheet = \PhpOffice\PhpSpreadsheet\IOFactory::load($file->getPathname());
        $sheetData = $spreadsheet->getActiveSheet()->toArray(null, true, true, true);
        $sheetData = array_slice($sheetData, 1);
        // Create record in carganotificacion table
        $cargaNotificacion = CargaNotifications::create([
            'fecha' => now(),
            'org_id' => $req->input('empresa'),
            'created_at' => now(),
            'updated_at' => now()
        ]);

try {
    // Create record in carganotificacion table
    $cargaNotificacion = CargaNotifications::create([
        'fecha' => now(),
        'org_id' => $req->input('empresa'),
        'created_at' => now(),
        'updated_at' => now()
    ]);

        // Get the generated ID
        $cargaId = $cargaNotificacion->idcarga;

        
        foreach ($sheetData as $row) {
            
                Notifications::create([
                            'org_id' => $req->input('empresa'),
                            'idcarga' => $cargaId,
                            'correo' => $row['B'],
                            'usuario' => $row['C'],
                            'fechalectura' => \Carbon\Carbon::createFromFormat('m/d/Y H:i', $row['D'])->format('Y-m-d H:i:s'),
                            'tipoboletin' => $row['E'],
                            'updated_at' => now(),
                            'created_at' => now()  
                            ]);
        }

        return redirect()->back()->with('success', 'El archivo se ha cargado correctamente.');
    } catch (\Exception $e) {
        return redirect()->back()->with('error', 'Ocurrió un error al cargar el archivo: ' . __($e->getMessage()));
    }

    }
    public function destroy($idcarga){
        Notifications::where('idcarga', $idcarga)->delete();
        CargaNotifications::where('idcarga', $idcarga)->delete();

        return redirect()->back()->with('success', 'El registro se ha eliminado correctamente.');
    }
    public function listarCargas(Request $req)
    {
        $user = Auth::user();
       // Coloca valores para menu activo y breadcumbs
        $this->_util->inicializaMenu($req);
        $req->session()->put('activeCarg',  Lang::get('carga.actList'));
        $req->session()->put('varList',  Lang::get('carga.active'));
        $req->session()->put('breadCumbp',Lang::get('carga.breadcumCarg'));
        $req->session()->put('breadCumbs',Lang::get('carga.detailbreadcumList'));
        $req->session()->put('breadImg', Lang::get('carga.icoCarg'));

        date_default_timezone_set('America/Guayaquil');
$startDate = $req->input('start_date') ?: date('Y-m-01');
$endDate = $req->input('end_date') ?: date('Y-m-d');

/*var_dump($startDate);
var_dump($endDate);
exit(); */
// Get all records from carganotificacion table with organization details
$cargas = CargaNotifications::select('carganotificacion.*')
    ->addSelect([
        'org_nombre' => Organizacion::on('dbVirtual')
            ->select('org_nombre')
            ->whereColumn('org_id', 'carganotificacion.org_id')
    ])
    ->whereDate('carganotificacion.fecha', '>=', $startDate)
    ->whereDate('carganotificacion.fecha', '<=', $endDate)
    ->orderBy('carganotificacion.fecha', 'desc')
    ->get();
    //var_dump($cargas);
    //exit();
return view('carga.listar', compact('cargas', 'startDate', 'endDate'));

    }
    
}
